/*
 * Decompiled with CFR 0.152.
 */
package filenet.vw.toolkit.design.visio.model.mapping;

import filenet.vw.api.VWActionType;
import filenet.vw.api.VWStepProcessorInfoDefinition;
import filenet.vw.api.VWWorkflowCollectionDefinition;
import filenet.vw.api.VWWorkflowDefinition;
import filenet.vw.apps.designer.VWDesignerCoreData;
import filenet.vw.base.VWDebug;
import filenet.vw.toolkit.design.visio.model.Connect;
import filenet.vw.toolkit.design.visio.model.DocumentObject;
import filenet.vw.toolkit.design.visio.model.Page;
import filenet.vw.toolkit.design.visio.model.Shape;
import filenet.vw.toolkit.design.visio.model.mapping.VWMappingFileWrapper;
import filenet.vw.toolkit.design.visio.model.mapping.VWProcessItem;
import filenet.vw.toolkit.design.visio.resources.VWResource;
import filenet.vw.toolkit.utils.VWFunctionStrings;
import filenet.vw.toolkit.utils.VWStringUtils;
import java.util.Hashtable;
import java.util.Vector;

public class VWMappingHelper {
    private static final int CATEGORY_PROCESS = 0;
    private static final int CATEGORY_FIELD = 1;
    private static final int CATEGORY_START_STEP = 2;
    private static final int CATEGORY_STEP = 3;
    private static final int CATEGORY_ROUTE = 4;
    private static final int CATEGORY_TEXT_ANNOTATION = 5;
    private static final int CATEGORY_ASSOCIATION = 6;
    protected static final int MESSAGE_TYPE_GENERAL = 0;
    protected static final int MESSAGE_TYPE_INFO = 1;
    protected static final int MESSAGE_TYPE_WARNING = 2;
    private VWDesignerCoreData m_designerCoreData = null;
    private VWMappingFileWrapper m_mappingFileWrapper = null;
    private boolean m_bShouldRenameNewWorkflows = true;
    private int m_nLocationPadding = 80;
    private String m_defaultStepProcessorName = null;
    private Vector m_processedPages = null;
    private Vector m_processItemList = null;
    private VWWorkflowCollectionDefinition m_newWorkflowCollection = null;
    private Hashtable m_wflnameList = null;
    private Vector m_messages = null;

    public VWMappingHelper(VWDesignerCoreData designerCoreData) {
        this.m_designerCoreData = designerCoreData;
    }

    public boolean getShouldRenameNewWorkflows() {
        return this.m_bShouldRenameNewWorkflows;
    }

    public void setShouldRenameNewWorkflows(boolean bShouldRenameNewWorkflows) {
        this.m_bShouldRenameNewWorkflows = bShouldRenameNewWorkflows;
    }

    public int getLocationPadding() {
        return this.m_nLocationPadding;
    }

    public void setLocationPadding(int nLocationPadding) {
        this.m_nLocationPadding = nLocationPadding;
    }

    public String[] createWorkflowProcesses(DocumentObject documentObj, VWMappingFileWrapper mappingFileWrapper) {
        Vector pages;
        this.m_mappingFileWrapper = mappingFileWrapper;
        this.m_processedPages = new Vector();
        this.m_processItemList = new Vector();
        this.m_newWorkflowCollection = new VWWorkflowCollectionDefinition();
        this.m_messages = new Vector();
        this.m_wflnameList = new Hashtable();
        try {
            String fileName = documentObj.getFileName();
            if (fileName != null) {
                this.m_newWorkflowCollection.setName(fileName);
            }
        }
        catch (Exception ex) {
            VWDebug.logException(ex);
        }
        if (documentObj != null && (pages = documentObj.getPages()) != null && pages.size() > 0) {
            int nIndex;
            for (nIndex = 0; nIndex < pages.size(); ++nIndex) {
                Page page = (Page)pages.elementAt(nIndex);
                if (page == null || !page.isSelected()) continue;
                this.addMessage(0, VWResource.s_pageColon.toString(page.getNameU()));
                page.resetProcessItems();
                this.evaluatePage(page, this.m_bShouldRenameNewWorkflows, pages);
            }
            for (nIndex = 0; nIndex < this.m_processItemList.size(); ++nIndex) {
                VWProcessItem processItem = (VWProcessItem)this.m_processItemList.elementAt(nIndex);
                processItem.rejustifyItems();
            }
        }
        if (this.m_messages != null && this.m_messages.size() > 0) {
            Object[] messages = new String[this.m_messages.size()];
            this.m_messages.copyInto(messages);
            return messages;
        }
        return null;
    }

    public VWWorkflowCollectionDefinition getNewWorkflows() {
        return this.m_newWorkflowCollection;
    }

    protected void addMessage(int nType, String message) {
        String formattedMessage = null;
        switch (nType) {
            case 1: {
                formattedMessage = "   " + VWResource.s_infoMarker.toString(message);
                break;
            }
            case 2: {
                formattedMessage = "   " + VWResource.s_warningMarker.toString(message);
                break;
            }
            default: {
                formattedMessage = message;
            }
        }
        if (formattedMessage != null && this.m_messages != null) {
            this.m_messages.addElement(formattedMessage);
        }
    }

    protected String getDefaultStepProcessorName() {
        VWStepProcessorInfoDefinition spInfoDef;
        if (this.m_defaultStepProcessorName == null && (spInfoDef = this.m_designerCoreData.getDataDictionary().getDefaultStepProcessor(1)) != null) {
            this.m_defaultStepProcessorName = spInfoDef.getName();
        }
        return this.m_defaultStepProcessorName;
    }

    private void evaluatePage(Page page, boolean bShouldRenameNewWorkflows, Vector pages) {
        try {
            VWProcessItem myProcessItem;
            Vector connects;
            VWProcessItem myProcessItem2;
            Vector offPageReferenceList = new Vector();
            Vector processList = new Vector();
            Vector fieldList = new Vector();
            Vector startStepList = new Vector();
            Vector stepList = new Vector();
            Vector routeList = new Vector();
            Vector textAnnotationList = new Vector();
            Vector associationList = new Vector();
            double maxY = 0.0;
            Vector shapes = page.getShapes();
            if (shapes != null && shapes.size() > 0) {
                block11: for (int nIndex = 0; nIndex < shapes.size(); ++nIndex) {
                    Shape shape = (Shape)shapes.elementAt(nIndex);
                    String fnObjectName = this.m_mappingFileWrapper.lookUpShape(shape);
                    shape.setDesignerObjectName(fnObjectName);
                    shape.setApiObject(null);
                    offPageReferenceList = this.addShapeToOffPageReferenceList(shape, page, offPageReferenceList, pages);
                    if (shape.getPinY() > maxY) {
                        maxY = shape.getPinY();
                    }
                    switch (this.getCategory(fnObjectName)) {
                        case 0: {
                            myProcessItem2 = this.addWorkflow(shape, shape.getText(), bShouldRenameNewWorkflows, page.getNameU());
                            if (myProcessItem2 == null) continue block11;
                            processList.addElement(myProcessItem2);
                            continue block11;
                        }
                        case 1: {
                            fieldList.addElement(shape);
                            continue block11;
                        }
                        case 2: {
                            startStepList.addElement(shape);
                            continue block11;
                        }
                        case 3: {
                            stepList.addElement(shape);
                            continue block11;
                        }
                        case 4: {
                            routeList.addElement(shape);
                            continue block11;
                        }
                        case 5: {
                            textAnnotationList.addElement(shape);
                            continue block11;
                        }
                        case 6: {
                            associationList.addElement(shape);
                        }
                    }
                }
            }
            if ((routeList.size() > 0 || associationList.size() > 0) && (connects = page.getConnects()) != null) {
                for (int nIndex = 0; nIndex < connects.size(); ++nIndex) {
                    Connect connect = (Connect)connects.elementAt(nIndex);
                    Shape fromShape = connect.getFromShape();
                    if (fromShape == null) continue;
                    if (VWStringUtils.compare(connect.getFromCell(), "BeginX") == 0) {
                        fromShape.setFromShape(connect.getToShape());
                        continue;
                    }
                    if (VWStringUtils.compare(connect.getFromCell(), "EndX") != 0) continue;
                    fromShape.setToShape(connect.getToShape());
                }
            }
            int nPageHeight = (int)(maxY * (double)this.m_nLocationPadding) + this.m_nLocationPadding;
            boolean bAddedDefaultProcess = false;
            if (processList.size() == 0 && (processList = this.addReferencedProcessItems(offPageReferenceList, processList)).size() == 0 && (myProcessItem = this.addWorkflow(null, page.getNameU(), bShouldRenameNewWorkflows, page.getNameU())) != null) {
                processList.addElement(myProcessItem);
                bAddedDefaultProcess = true;
            }
            if (processList.size() > 0) {
                for (int nIndex = 0; nIndex < processList.size(); ++nIndex) {
                    VWProcessItem newProcessItem;
                    myProcessItem2 = (VWProcessItem)processList.elementAt(nIndex);
                    fieldList = myProcessItem2.setFields(fieldList, this);
                    stepList = myProcessItem2.setSteps(stepList, this);
                    startStepList = myProcessItem2.setStartSteps(startStepList);
                    routeList = myProcessItem2.setRoutes(routeList);
                    textAnnotationList = myProcessItem2.setTextAnnotations(textAnnotationList);
                    associationList = myProcessItem2.setAssociations(associationList);
                    myProcessItem2.convertShapes(this, nPageHeight);
                    page.addProcessItem(myProcessItem2);
                    if (bAddedDefaultProcess || nIndex != processList.size() - 1 || fieldList.size() <= 0 && stepList.size() <= 0 && startStepList.size() <= 0 && textAnnotationList.size() <= 0) continue;
                    int nSize = processList.size();
                    if ((processList = this.addReferencedProcessItems(offPageReferenceList, processList)).size() != nSize || (newProcessItem = this.addWorkflow(null, page.getNameU(), bShouldRenameNewWorkflows, page.getNameU())) == null) continue;
                    processList.addElement(newProcessItem);
                    bAddedDefaultProcess = true;
                }
            }
            this.m_processedPages.addElement(page);
        }
        catch (Exception ex) {
            VWDebug.logException(ex);
        }
    }

    private Vector addShapeToOffPageReferenceList(Shape shape, Page page, Vector offPageReferenceList, Vector pages) {
        String referencePageId;
        if (VWStringUtils.compare(shape.getNameU(), "Off-page reference") == 0 && (referencePageId = shape.getReferencePageId()) != null && VWStringUtils.compare(referencePageId, page.getUniqueID()) != 0) {
            boolean bFound = false;
            for (int nIdx = 0; nIdx < offPageReferenceList.size(); ++nIdx) {
                Shape tmpShape = (Shape)offPageReferenceList.elementAt(nIdx);
                if (VWStringUtils.compare(tmpShape.getReferencePageId(), referencePageId) != 0) continue;
                bFound = true;
                break;
            }
            if (!bFound) {
                offPageReferenceList.addElement(shape);
                this.checkForSelectedPage(referencePageId, pages);
            }
        }
        return offPageReferenceList;
    }

    private void checkForSelectedPage(String referencePageId, Vector pages) {
        if (pages != null) {
            for (int nIndex = 0; nIndex < pages.size(); ++nIndex) {
                Page page = (Page)pages.elementAt(nIndex);
                if (page == null || VWStringUtils.compare(page.getUniqueID(), referencePageId) != 0 || page.isSelected()) continue;
                this.addMessage(2, VWResource.s_referencedPageNotSelected.toString(page.getNameU()));
            }
        }
    }

    private int getCategory(String fnObjectName) {
        if (VWActionType.isValid(VWFunctionStrings.getActionType(fnObjectName))) {
            return 3;
        }
        if (VWStringUtils.compare(fnObjectName, VWResource.s_start) == 0) {
            return 2;
        }
        if (VWStringUtils.compare(fnObjectName, VWResource.s_component) == 0) {
            return 3;
        }
        if (VWStringUtils.compare(fnObjectName, VWResource.s_general) == 0) {
            return 3;
        }
        if (VWStringUtils.compare(fnObjectName, VWResource.s_system) == 0) {
            return 3;
        }
        if (VWStringUtils.compare(fnObjectName, VWResource.s_submap) == 0) {
            return 3;
        }
        if (VWStringUtils.compare(fnObjectName, VWResource.s_route) == 0) {
            return 4;
        }
        if (VWStringUtils.compare(fnObjectName, VWResource.s_association) == 0) {
            return 6;
        }
        if (VWStringUtils.compare(fnObjectName, VWResource.s_textAnnotation) == 0) {
            return 5;
        }
        if (VWStringUtils.compare(fnObjectName, VWResource.s_workflowProcess) == 0) {
            return 0;
        }
        if (VWStringUtils.compare(fnObjectName, VWResource.s_attachment) == 0) {
            return 1;
        }
        if (VWStringUtils.compare(fnObjectName, VWResource.s_dataField) == 0) {
            return 1;
        }
        if (VWStringUtils.compare(fnObjectName, VWResource.s_workflowGroup) == 0) {
            return 1;
        }
        if (VWStringUtils.compare(fnObjectName, VWResource.s_xmlDataField) == 0) {
            return 1;
        }
        return -1;
    }

    private VWProcessItem addWorkflow(Shape shape, String wflName, boolean bShouldRenameNewWorkflows, String pageName) {
        try {
            if (wflName == null || wflName.trim().length() == 0) {
                int nIndex = 1;
                if (this.m_newWorkflowCollection.getWorkflows() != null) {
                    nIndex = this.m_newWorkflowCollection.getWorkflows().length + 1;
                }
                wflName = VWResource.s_workflow + nIndex;
            } else if (this.m_wflnameList.containsKey(wflName)) {
                wflName = (String)this.m_wflnameList.get(wflName);
            }
            VWProcessItem processItem = this.findProcessItem(wflName);
            if (processItem != null) {
                processItem.setShape(shape);
                processItem.setDefaultMapName(pageName);
                return processItem;
            }
            VWWorkflowCollectionDefinition currentWflCol = this.m_designerCoreData.getProcessMenuHelper().getWorkflowCollectionDefinition();
            if (currentWflCol.isExistingWorkflowName(wflName)) {
                if (bShouldRenameNewWorkflows) {
                    String newWflName;
                    int nCounter = 1;
                    while (currentWflCol.isExistingWorkflowName(newWflName = wflName + nCounter++)) {
                    }
                    this.m_wflnameList.put(wflName, newWflName);
                    wflName = newWflName;
                    this.addMessage(2, VWResource.s_renameNewWorkflow.toString(newWflName));
                } else {
                    this.addMessage(2, VWResource.s_replaceExistingWorkflow);
                }
            }
            VWWorkflowDefinition newWorkflowDef = new VWWorkflowDefinition();
            newWorkflowDef.setName(wflName);
            this.m_newWorkflowCollection.addWorkflow(newWorkflowDef);
            this.addMessage(1, VWResource.s_addedWorkflow.toString(wflName));
            processItem = new VWProcessItem(shape, newWorkflowDef);
            this.m_processItemList.addElement(processItem);
            return processItem;
        }
        catch (Exception ex) {
            VWDebug.logException(ex);
            return null;
        }
    }

    private VWProcessItem findProcessItem(String wflName) {
        if (this.m_processItemList != null) {
            for (int nIndex = 0; nIndex < this.m_processItemList.size(); ++nIndex) {
                VWProcessItem processItem = (VWProcessItem)this.m_processItemList.elementAt(nIndex);
                if (VWStringUtils.compare(processItem.getName(), wflName) != 0) continue;
                return processItem;
            }
        }
        return null;
    }

    private Vector addReferencedProcessItems(Vector offPageReferenceList, Vector processList) {
        block0: for (int nIdx1 = 0; nIdx1 < offPageReferenceList.size(); ++nIdx1) {
            Shape tmpShape = (Shape)offPageReferenceList.elementAt(nIdx1);
            String referencePageId = tmpShape.getReferencePageId();
            for (int nIdx2 = 0; nIdx2 < this.m_processedPages.size(); ++nIdx2) {
                Page tmpPage = (Page)this.m_processedPages.elementAt(nIdx2);
                if (VWStringUtils.compare(tmpPage.getUniqueID(), referencePageId) != 0) continue;
                Vector processItems = tmpPage.getProcessItems();
                if (processItems == null) continue block0;
                for (int nIdx3 = 0; nIdx3 < processItems.size(); ++nIdx3) {
                    VWProcessItem pageProcessItem = (VWProcessItem)processItems.elementAt(nIdx3);
                    boolean bFound = false;
                    for (int nIdx4 = 0; nIdx4 < processList.size(); ++nIdx4) {
                        VWProcessItem tmpProcessItem = (VWProcessItem)processList.elementAt(nIdx4);
                        if (VWStringUtils.compare(tmpProcessItem.getName(), pageProcessItem.getName()) != 0) continue;
                        bFound = true;
                        break;
                    }
                    if (bFound) continue;
                    pageProcessItem.setShape(null);
                    processList.addElement(pageProcessItem);
                }
                continue block0;
            }
        }
        return processList;
    }
}

